set more off 
pause on
set logtype text
set mem 500M


*************** DESCRIPTION *************************************
* Downloads a variety of Macro-data fields from FRED
*
*	Input: 		FRED, downloaded using freduse
*	Output: 	0.raw_inputs\fred_annual, 0.raw_inputs\fred_quarter
*				0.raw_inputs\fred_month		
*
* NOTATION:
* 	y = GDP
*	c09_y = GDP in chained 2009 $
* 	yq = GDP quantity , Index 2009=100
* 	r = interest rate
* 	i = gross private domestic fixed investment, qx, c09x
* 	ni = net private domestic fixed investment
* 	iy = investment over GDP
* 	y_nfcb = gross value added of non financial corporate business sector
* 	a_ = assets
* 	l_ = liabilities
* 	krc = non financial assets at replacement cost
* 	deprec = depreciation, i.e., consumption of fixed capital
*
*****************************************************************


/* ---------------------- */
/*		MONTHLY DATA	  */
/* ---------------------- */

* CPIAUCNS: Consumer Price Index for All Urban Consumers: All Items, Index 1982-1984=100, Monthly, Not Seasonally Adjusted, 
* AAA: Moody's Seasoned Aaa Corporate Bond Yield
* BAA: Moody's Seasoned Baa Corporate Bond Yield
* TB3MS: 3-Month Treasury Bill: Secondary Market Rate, Monthly, Not Seasonally Adjusted
* GS10: 10-Year Treasury Constant Maturity Rate, Monthly, Not Seasonally Adjusted
* FII10: 10-Year Treasury Inflation-Indexed Security, Constant Maturity
* UNRATE: Civilian Unemployment Rate, Monthly, Seasonally Adjusted
* EMRATIO: Civilian Employment-Population Ratio, Monthly, Seasonally Adjusted
* POP: Total Population: All Ages including Armed Forces Overseas, Thousands, Monthly, Not Seasonally Adjusted
* AWHNONAG: Average Weekly Hours Of Production And Nonsupervisory Employees: Total private, Monthly, Seasonally Adjusted
* AWHI: Index of Aggregate Weekly Hours: Production and Nonsupervisory Employees: Total Private Industries, Monthly, Seasonally Adjusted, Index 2002=100
* MICH: University of Michigan: Inflation Expectation, Monthly, Not Seasonally Adjusted

freduse CPIAUCSL AAA BAA TB3MS GS1 GS10 FII10 UNRATE EMRATIO POP AWHNONAG AWHI MICH , clear
g year = year(daten)
g month = month(daten)
drop date daten
compress
sort year month
foreach X in AAA BAA TB3MS GS1 GS10 FII10 UNRATE EMRATIO MICH {
replace `X'=`X'/100
}

*

compress
rename TB3MS r_tb3m
rename GS1 r_gs1
rename GS10 r_gs10
rename FII10 r_rty10
rename AAA r_aaa
rename BAA r_baa
rename CPIAUCSL p_cpi
rename UNRATE unr
rename EMRATIO emprate_civil
rename AWHNONAG hw_prod
rename AWHI htot_prod
rename POP pop
replace pop = pop/1000
rename MICH infl_mich
sort year month
save 0.raw_inputs\fred_month, replace



***



/* --------------------- */ 
/* 		QUARTERLY DATA	 */ 
/* --------------------- */ 


* NOMINAL GDP
* GDP: Gross Domestic Product, Quarterly, Seasonally Adjusted Annual Rate, Billions of Dollars
* PCEC: Personal Consumption Expenditures, Quarterly, Seasonally Adjusted Annual Rate, Billions of Dollars
* PCND: Personal Consumption Expenditures: Nondurable Goods, Quarterly, Seasonally Adjusted Annual Rate, Billions of Dollars
* PCDG: Personal Consumption Expenditures: Durable Goods, Quarterly, Seasonally Adjusted Annual Rate, Billions of Dollars 
* PCESV: Personal Consumption Expenditures: Services, Quarterly, Seasonally Adjusted Annual Rate, Billions of Dollars 
* A006RE1Q156NBEA: Shares of gross domestic product: Gross private domestic investment, Quarterly, Not Seasonally Adjusted
* A007RE1Q156NBEA: Shares of gross domestic product: Gross private domestic investment: Fixed investment
* A008RE1Q156NBEA: Shares of gross domestic product: Gross private domestic investment: Fixed investment: Nonresidential
* B009RE1Q156NBEA: Shares of gross domestic product: Gross private domestic investment: Fixed investment: Nonresidential: Structures
* B010RE1Q156NBEA: Shares of gross domestic product: Gross private domestic investment: Fixed investment: Nonresidential: Equipment and software
* Y001RE1Q156NBEA: Shares of Gross Domestic Product: Gross Private Domestic Investment: Fixed Investment: Nonresidential: Intellectual Property Products, Quarterly, Seasonally Adjusted,
* A011RE1Q156NBEA: Shares of gross domestic product: Gross private domestic investment: Fixed investment: Residential, Quarterly, Not Seasonally Adjusted
* A014RE1Q156NBEA: Shares of gross domestic product: Gross private domestic investment: Change in private inventories

* PRICE DEFLATORS FOR OUTPUT AND INVESTMENT
* GDPDEF: Gross Domestic Product: Implicit Price Deflator, Index 2009=100, Quarterly, Seasonally Adjusted
* IPDNBS: Nonfarm Business Sector: Implicit Price Deflator, Index 2009=100, Quarterly, Seasonally Adjusted,
* A007RD3Q086SBEA: Gross private domestic investment: Fixed investment (implicit price deflator), Index 2009=100, Quarterly, Seasonally Adjusted,
* A008RD3Q086SBEA: Gross private domestic investment: Fixed investment: Nonresidential (implicit price deflator)
* A009RD3Q086SBEA: Gross private domestic investment: Fixed investment: Nonresidential: Structures (implicit price deflator)
* A010RD3Q086SBEA: Gross private domestic investment: Fixed investment: Nonresidential: Equipment and software (implicit price deflator)
* Y001RD3Q086SBEA: Gross Private Domestic Investment: Fixed Investment: Nonresidential: Intellectual Property Products: Implicit Price Deflator, Index 2009=100, Quarterly, Seasonally Adjusted
* A011RD3Q086SBEA: Gross private domestic investment: Fixed investment: Residential (implicit price deflator)

* CHAINED $2009
* GDPC1: Real Gross Domestic Product, Billions of Chained 2009 Dollars, Quarterly, Seasonally Adjusted Annual Rate
* GPDIC1: Real Gross Private Domestic Investment, Billions of Chained 2009 Dollars, Quarterly, Seasonally Adjusted Annual Rate

* CHAINED QUANTITY INDEXES
* B191RA3Q086SBEA: Real gross domestic product (chain-type quantity index), Index 2009=100, Quarterly, Seasonally Adjusted, 
* DPCERA3Q086SBEA: Real personal consumption expenditures (chain-type quantity index), Index 2009=100, Quarterly, Seasonally Adjusted, 
* DNDGRA3Q086SBEA: Real personal consumption expenditures: Nondurable goods (chain-type quantity index), Index 2009=100, Quarterly, Seasonally Adjusted, 
* B006RA3Q086SBEA: Real gross private domestic investment (chain-type quantity index), 2009=100, Quarterly, Seasonally Adjusted
* B008RA3Q086SBEA: Real private fixed investment: Nonresidential (chain-type quantity index) 2009=100, Quarterly, Seasonally Adjusted
* B009RA3Q086SBEA: Real private fixed investment: Nonresidential: Structures (chain-type quantity index) 2009=100, Quarterly, Seasonally Adjusted
* B010RA3Q086SBEA: Real private fixed investment: Nonresidential: Equipment and software (chain-type quantity index) 2009=100, Quarterly, Seasonally Adjusted
* Y001RA3Q086SBEA: Real Gross Private Domestic Investment: Fixed Investment: Nonresidential: Intellectual Property Products (chain-type quantity index) 2009=100, Quarterly, Seasonally Adjusted

* EMPLOYMENT AND POPULATION
* LFWA64TTUSQ647N: Working Age Population: Aged 15-64: All Persons for the United States, Quarterly, Not Seasonally Adjusted
* LREM25TTUSQ156S: Employment Rate: Aged 25-54: All Persons for the United States, Quarterly, Seasonally Adjusted
* LREM64TTUSQ156S: Employment Rate: Aged 15-64: All Persons for the United States, Quarterly, Seasonally Adjusted


freduse GDP PCEC PCND PCDG PCESV A008RE1Q156NBEA B010RE1Q156NBEA GDPDEF IPDNBS A008RD3Q086SBEA A009RD3Q086SBEA A010RD3Q086SBEA Y001RD3Q086SBEA ///
GDPC1 GPDIC1 B191RA3Q086SBEA DPCERA3Q086SBEA DNDGRA3Q086SBEA B006RA3Q086SBEA B008RA3Q086SBEA B009RA3Q086SBEA B010RA3Q086SBEA Y001RA3Q086SBEA ///
LFWA64TTUSQ647N LREM25TTUSQ156S LREM64TTUSQ156S Y001RE1Q156NBEA A011RE1Q156NBEA B009RE1Q156NBEA , clear
g year = year(daten)
g qtr = quarter(daten)
drop date daten
compress
sort year qtr
save 0.raw_inputs\fred_quarter, replace

*

use 0.raw_inputs\fred_quarter, clear

rename GDP y
rename PCEC c
rename PCND cnd
rename PCDG cd
rename PCESV cs
g i_nonres = y*A008RE1Q156NBEA/100
g i_equisoft = y*B010RE1Q156NBEA/100
g i_ip = y*Y001RE1Q156NBEA/100
g i_res = y*A011RE1Q156NBEA/100
g i_struc = y*B009RE1Q156NBEA/100
drop A008RE1Q156NBEA B009RE1Q156NBEA B010RE1Q156NBEA Y001RE1Q156NBEA B010RE1Q156NBEA A011RE1Q156NBEA

label variable y "GDP"
label variable c "Personal Consumption Expenditures"
label variable cnd "Non Durable Consumption Expenditures"
label variable cd "Durable Consumption Expenditures"
label variable cs "Services Consumption Expenditures"
label variable i_nonres "Private Investment: Nonresidential "
label variable i_equisoft "Private Investment: Equi.& Soft."

rename GDPDEF p_gdp
rename IPDNBS p_nonfarmbus
rename A008RD3Q086SBEA p_i_nonres
rename A009RD3Q086SBEA p_i_struct
rename A010RD3Q086SBEA p_i_equisoft
rename Y001RD3Q086SBEA p_i_intell

rename GDPC1 yc09
rename GPDIC1 ic09_tot
rename B191RA3Q086SBEA yq
rename DPCERA3Q086SBEA cq
rename DNDGRA3Q086SBEA cndq
rename B006RA3Q086SBEA iq_tot
rename B008RA3Q086SBEA iq_nonres
rename B009RA3Q086SBEA iq_struct
rename B010RA3Q086SBEA iq_equisoft
rename Y001RA3Q086SBEA iq_intell

rename LFWA64TTUSQ647N pop1564
rename LREM25TTUSQ156S emprate2554
rename LREM64TTUSQ156S emprate1564
replace pop1564 = pop1564/1000000

label variable yq "GDP Index"
label variable cq "Personal Consumption Expenditures Index"
label variable cndq "Non Durable Consumption Expenditures Index"
label variable iq_tot "Private Investment Index"
label variable iq_nonres "Private Investment Index: Nonresidential "
label variable iq_intell "Private Investment Index: Intellectual"
label variable iq_equisoft "Private Investment Index: Equi.& Soft."
label variable iq_struct "Private Investment Index: Structures"
compress
sort year qtr
save 0.raw_inputs\fred_quarter, replace



*** NON FINANCIAL CORPORATE SECTOR: QUARTERLY DATA ***

* NOMINAL ASSETS & LIABILITIES
* TABSNNCB:   Nonfinancial Corporate Business; Total Assets, Level, Billions
* TTAABSNNCB: Nonfinancial Corporate Business; Non Financial Assets, Level, Billions
* NCBREMV:    Nonfinancial Corporate Business; Real Estate at Market Value
* ESABSNNCB:  Nonfinancial Corporate Business; Equipment, Current Cost Basis, Level, Billions
* NCBNIPPCCB: Nonfinancial Corporate Business; Nonresidential Intellectual Property Products, Current Cost Basis
* IABSNNCB:   Nonfinancial Corporate Business; Inventories Excluding Iva, Current Cost Basis, Level
* TFAABSNNCB: Nonfinancial Corporate Business; Total Financial Assets, Level
* MAABSNNCB:  Nonfinancial Corporate Business; Total Miscellaneous Assets, Level
* TLBSNNCB:   Nonfinancial Corporate Business; Total Liabilities, Level, Billions
* NCBDSL:     Nonfinancial Corporate Business; Debt Securities; Liability, Millions
* NCBLL:      Nonfinancial Corporate Business; Loans; Liability, Millions
* MLLBSNNCB:  Nonfinancial Corporate Business; Total Miscellaneous Liabilities
* NCBCEL:     Nonfinancial Corporate Business; Corporate Equities; Liability, Level, Billions
* TNWMVBSNNCB:     Nonfinancial Corporate Business; Net Worth, Level, Billions of Dollars
* RCVSRNWMVBSNNCB: Nonfinancial Corporate Business; Residential Structures, Current Cost Basis, Level
* RCSNNWMVBSNNCB:  Nonfinancial Corporate Business; Nonresidential Structures, Current Cost Basis, Level

* CHAINED $2009
* B455RX1Q027SBEA: Real Gross value added of nonfinancial corporate business, Billions of Chained 2009 Dollars, Quarterly, Seasonally Adjusted Annual Rate, 
* N456RX1Q027SBEA: Real gross value added of nonfinancial corporate business: Consumption of fixed capital, Billions of Chained 2009 Dollars, Quarterly, Seasonally Adjusted Annual Rate

* NOMINAL VALUE ADDED AND INVESTMENT
* B465RC1Q027SBEA: Net value added of nonfinancial corporate business: Corporate profits with IVA and CCAdj: Taxes on corporate income
* W327RC1Q027SBEA: Net value added of nonfinancial corporate business: n operating surplus: Business current transfer payments (n)

freduse TABSNNCB TTAABSNNCB NCBREMV ESABSNNCB NCBNIPPCCB IABSNNCB TFAABSNNCB MAABSNNCB MLLBSNNCB ///
TLBSNNCB NCBDSL NCBLL NCBCEL TNWMVBSNNCB RCVSRNWMVBSNNCB RCSNNWMVBSNNCB B455RX1Q027SBEA N456RX1Q027SBEA ///
NCBGVAQ027S NCBCCFQ027S NCBCEPQ027S NCBSCPQ027S W325RC1Q027SBEA NCBOSNQ027S B465RC1Q027SBEA W327RC1Q027SBEA NCBGCFQ027S NCBFNEQ027S, clear
g year = year(daten)
g qtr = quarter(daten)
drop date daten
compress
sort year qtr
merge 1:1 year qtr using 0.raw_inputs\fred_quarter
drop _merge
compress
sort year qtr
save 0.raw_inputs\fred_quarter, replace

*

use 0.raw_inputs\fred_quarter, clear

rename TABSNNCB 	a_tot_nfcb
rename TTAABSNNCB 	a_nonfin_nfcb
rename NCBREMV 		a_realestate_mv_nfcb
rename ESABSNNCB 	a_equip_nfcb
rename NCBNIPPCCB 	a_intell_nfcb
rename IABSNNCB 	a_inventories_nfcb
rename TFAABSNNCB 	a_fin_nfcb
rename MAABSNNCB 	a_misc_nfcb
rename TLBSNNCB 	l_tot_nfcb
rename MLLBSNNCB 	l_misc_nfcb
rename NCBDSL 		l_debt_nfcb
rename NCBLL 		l_loans_nfcb
rename NCBCEL 		  mve_nfcb
rename TNWMVBSNNCB 	  nw_nfcb
rename RCVSRNWMVBSNNCB 	krc_res_nfcb
rename RCSNNWMVBSNNCB 	krc_nonres_nfcb

rename B455RX1Q027SBEA yc09_nfcb
rename N456RX1Q027SBEA depc09_nfcb

* put all variables in billions
foreach x in l_debt l_loans {
replace `x' = `x'/1000
}
* notice accounting identities
* tota = nfa + fina
* nfa = realestate_mv + equip + intel + inventories
* nw = tota - totl
egen test1 =  max((a_tot-l_tot-nw)/a_tot)
egen test2 =  max((a_tot-a_nonfin-a_fin)/a_tot)
egen test3 =  max((a_realestate_mv + a_equip + a_intell + a_inventories - a_nonfin)/a_nonfin)
su test*
drop test*
compress
sort year qtr
save 0.raw_inputs\fred_quarter, replace

*/

*** NON FINANCIAL NON-CORPORATE SECTOR ***

* NOMINAL ASSETS & LIABILITIES
* TABSNNB:   Nonfinancial Non-Corporate Business; Total Assets, Level, Billions
* TTAABSNNB: Nonfinancial Non-Corporate Business; Non Financial Assets, Level, Billions
* NNBREMV:    Nonfinancial Non-Corporate Business; Real Estate at Market Value
* ESABSNNB:  Nonfinancial Non-Corporate Business; Equipment, Current Cost Basis, Level, Billions
* NNBNIPPCCB: Nonfinancial Non-Corporate Business; Nonresidential Intellectual Property Products, Current Cost Basis
* IABSNNB:   Nonfinancial Non-Corporate Business; Inventories Excluding Iva, Current Cost Basis, Level
* TFAABSNNB: Nonfinancial Non-Corporate Business; Total Financial Assets, Level
* MAABSNNB:  Nonfinancial Non-Corporate Business; Total Miscellaneous Assets, Level
* TLBSNNB:   Nonfinancial Non-Corporate Business; Total Liabilities, Level, Billions
* NNBLL:      Nonfinancial Non-Corporate Business; Loans; Liability, Millions
* MLLBSNNB:  Nonfinancial Non-Corporate Business; Total Miscellaneous Liabilities
* RCVSRNWBSNNB: Nonfinancial Non-Corporate Business; Residential Structures, Current Cost Basis, Level
* RCVSNWBSNNB:  Nonfinancial Non-Corporate Business; Nonresidential Structures, Current Cost Basis, Level


freduse TABSNNB TTAABSNNB NNBREMV ESABSNNB NNBNIPPCCB IABSNNB TFAABSNNB MAABSNNB MLLBSNNB ///
TLBSNNB NNBLL RCVSRNWBSNNB RCVSNWBSNNB ///
NNBGVAQ027S NNBCCFQ027S NNBCEPQ027S NNBGFNQ027S , clear
g year = year(daten)
g qtr = quarter(daten)
drop date daten
compress
sort year qtr
merge 1:1 year qtr using 0.raw_inputs\fred_quarter
drop _merge
compress
sort year qtr
save 0.raw_inputs\fred_quarter, replace

*

use 0.raw_inputs\fred_quarter, clear

rename TABSNNB 			a_tot_nfncb
rename TTAABSNNB 		a_nonfin_nfncb
rename NNBREMV 			a_realestate_mv_nfncb
rename ESABSNNB 		a_equip_nfncb
rename NNBNIPPCCB 		a_intell_nfncb
rename IABSNNB 			a_inventories_nfncb
rename TFAABSNNB 		a_fin_nfncb
rename MAABSNNB 		a_misc_nfncb
rename TLBSNNB 			l_tot_nfncb
rename MLLBSNNB 		l_misc_nfncb
rename NNBLL 			l_loans_nfncb
rename RCVSRNWBSNNB 	krc_res_nfncb
rename RCVSNWBSNNB 		krc_nonres_nfncb


* put all variables in billions
foreach x in l_loans_nfncb  {
replace `x' = `x'/1000
}
* notice accounting identities
* tota = nfa + fina
* nfa = realestate_mv + equip + intel + inventories
* nw = tota - totl
egen test2 =  max((a_tot_nfncb-a_nonfin_nfncb-a_fin_nfncb)/a_tot_nfncb)
su test*
drop test*
compress
sort year qtr
save 0.raw_inputs\fred_quarter, replace


***


/* --------------------- */ 
/* 		ANNUAL DATA		 */ 
/* --------------------- */ 

*** MACRO-DATA

* NOMINAL
* PNFIA: 		Private Nonresidential Fixed Investment, $Billions
* PRFIA: 		Private Residential Fixed Investment, $Billions
* A438RC1A027NBEA: 	Consumption of fixed capital: Private: Domestic: Corporate business
* K1NTOTL1ES000: 	Current-Cost Net Stock of Fixed Assets: Private: Nonresidential, $Billions
* M1NTOTL1ES000: 	Current-Cost Depreciation of Fixed Assets: Private: Nonresidential, $Billions
* K1X53101ES000: 	Current-Cost Net Stock of Private and government fixed assets: Residential, $Billions
* M1X53101ES000: 	Current-Cost Depreciation of Private and government fixed assets: Residential, $Billions

* QUANTITY INDEX
* A191RA3A086NBEA: Real gross domestic product (chain-type quantity index), Index 2009=100
* A593RA3A086NBEA: Real Net fixed investment: Net nonresidential (chain-type quantity index), Index 2009=100
* A594RA3A086NBEA: Real Net fixed investment: Net nonresidential: n structures (chain-type quantity index), Index 2009=100
* A748RA3A086NBEA: Real Net fixed investment: Net residential (chain-type quantity index), Index 2009=100

* CHAINED $2009
* GDPCA: Real Gross Domestic Product, Billions of Chained 2009 Dollars
* PCECCA: Real personal consumption expenditures, Billions of Chained 2009 Dollars
* PNFICA: Real Net fixed investment: Net nonresidential, Billions of Chained 2009 Dollars
* A593RX1A020NBEA: Real Net fixed investment: Net nonresidential, Billions of Chained 2009 Dollars
* A594RX1A020NBEA: Real Net fixed investment: Net nonresidential: Net structures, Billions of Chained 2009 Dollars

* B4701C0A222NBEA: Millions of Hours worked by full-time and part-time employees, Annual, Not Seasonally Adjusted

* DEFLATORS
* A191RD3A086NBEA: Gross domestic product (implicit price deflator), Index 2009=100
* DPCERD3A086NBEA: Personal consumption expenditures (implicit price deflator), Index 2009=100 (+ see more)
* A008RD3A086NBEA: Gross private domestic investment: Fixed investment: Nonresidential (implicit price deflator), Index 2009=100
* Y033RD3A086NBEA: Gross Private Domestic Investment: Fixed Investment: Nonresidential: Equipment: Implicit Price Deflators, Index 2009=100

freduse GDPA PNFIA PRFIA K1NTOTL1ES000 M1NTOTL1ES000 K1X53101ES000 M1X53101ES000 A438RC1A027NBEA ///
NCBOSNA027N NNBBOSA027N A191RA3A086NBEA PNFICA A593RA3A086NBEA A594RA3A086NBEA A748RA3A086NBEA ///
GDPCA PCECCA A593RX1A020NBEA A594RX1A020NBEA  B4701C0A222NBEA ///
A191RD3A086NBEA DPCERD3A086NBEA A008RD3A086NBEA Y033RD3A086NBEA , clear /* GDP, $ billions, annual */
g year = year(daten)
drop date daten
compress
sort year

rename GDPA y
rename PNFIA i_nonres
rename PRFIA i_res
rename K1NTOTL1ES000 	krc_nonres_priv
rename M1NTOTL1ES000 	dep_nonres_priv
rename K1X53101ES000 	krc_res_tot
rename M1X53101ES000 	dep_res_tot
rename A438RC1A027NBEA 	dep_cb
rename A191RA3A086NBEA 	yq
rename A593RA3A086NBEA 	niq_nonres
rename A594RA3A086NBEA 	niq_struct
rename A748RA3A086NBEA 	niq_res
rename GDPCA 			yc09
rename PCECCA			cc09
rename PNFICA 	ic09_nonres
rename A593RX1A020NBEA 	nic09_nonres
rename A594RX1A020NBEA 	nic09_struct
rename A191RD3A086NBEA  p_gdp
rename DPCERD3A086NBEA 	p_pce
rename A008RD3A086NBEA  p_i_nonres
rename Y033RD3A086NBEA  p_i_equip
rename B4701C0A222NBEA  htot

label variable yq "GDP"
label variable niq_nonres "Net Nonresidential Investment"
label variable niq_struct "Net Structure Investment"
label variable niq_res "Net Residential Investment"

label variable yc09 "GDP"
label variable cc09 "Private Consumption"
label variable nic09_nonres "Net Nonresidential Investment"
label variable nic09_struct "Net Structure Investment"

compress
sort year
save 0.raw_inputs\fred_annual, replace


*** NON FINANCIAL CORPORATE SECTOR ***
* We use annual data instead of quarterly because some fields are not available 
* quarterly for noncorporates social contributions

* CORPORATE: NOMINAL VALUE ADDED AND INVESTMENT
* NCBGVAA027N:     Nonfinancial corporate business; gross value added, Flow, SA, Millions 
* NCBCFCA027N:     Nonfinancial corporate business; consumption of fixed capital, equipment, software, and structures, including equity REIT residential structures (NIPA basis), Flow, SA, Millions
* NCBCEPA027N:     Nonfinancial corporate business; compensation of employees paid, Flow, Millions 
* NCBSCPA027N:     Nonfinancial corporate business; employers' social contributions paid, Flow, Millions 
* NCBOSNA027N:     Nonfinancial corporate business; operating surplus, n, Flow, SA, Millions
* NCBGFCA027N:     Nonfinancial corporate business; gross fixed capital formation with equity REITs (IMA), Flow, SA, Millions
* NCBFNEA027N:     Nonfinancial corporate business; capital formation, n (includes equity REITs) (IMA), Flow, SA, Millions
* NCBPISA027N: 	   Nonfinancial corporate business; taxes on production and imports less subsidies, payable, Flow
* B465RC1A027NBEA: Net value added of nonfinancial corporate business: Corporate profits with IVA and CCAdj: Taxes on corporate income, Millions 
* W327RC1A027NBEA: Net value added of nonfinancial corporate business: n operating surplus: Business current transfer payments (n), Millions 


* NON-CORPORATE: NOMINAL VALUE ADDED AND INVESTMENT
* NNBGVAA027N:     Nonfinancial Noncorporate business; gross value added, Flow, SA, Millions
* NNBCFCA027N:     Nonfinancial Noncorporate business; consumption of fixed capital, equipment, software, and structures, including equity REIT residential structures (NIPA basis), Flow, SA, Millions
* NNBCEPA027N:     Nonfinancial Noncorporate business; compensation of employees paid, Flow, Millions 
* NNBESCA027N:     Nonfinancial Noncorporate business; employers' social contributions paid, Flow, Millions 
* NNBBOSA027N: 	   Nonfinancial noncorporate business; operating surplus, n, Flow, Millions
* NNBGFNA027N: 	   Nonfinancial noncorporate business; gross fixed investment (IMA), Flow, Millions 		--> Analogous to gross fixed capital formation for nonfin corporates
* NNBCFNA027N:     Nonfinancial noncorporate business; capital formation, n (IMA), Flow, SA, Millions
* NNBTPIA027N:	   Nonfinancial noncorporate business; taxes on production and imports less subsidies, payable, Flow

freduse NCBGVAA027N NCBCFCA027N NCBCEPA027N NCBSCPA027N NCBOSNA027N NCBGFCA027N NCBFNEA027N ///
NCBPISA027N B465RC1A027NBEA W327RC1A027NBEA NNBGVAA027N NNBCFCA027N NNBCEPA027N ///
NNBESCA027N NNBTPIA027N NNBBOSA027N NNBGFNA027N NNBCFNA027N, clear
g year = year(daten)
drop date daten
compress
sort year
merge 1:1 year using 0.raw_inputs\fred_annual
drop _merge
compress
sort year 
save 0.raw_inputs\fred_annual, replace

*

use 0.raw_inputs\fred_annual, clear

rename NCBGVAA027N 		y_nfcb
rename NCBCFCA027N 		dep_nfcb
rename NCBCEPA027N 		wn_nfcb
rename NCBSCPA027N 		taxsocial_nfcb
rename NCBPISA027N 		taxprod_nfcb
rename NCBOSNA027N 		nos_nfcb
rename B465RC1A027NBEA 	taxinc_nfcb
rename W327RC1A027NBEA 	taxtrans_nfcb
rename NCBGFCA027N 		i_nfcb
rename NCBFNEA027N 		ni_nfcb

rename NNBGVAA027N 		y_nfncb
rename NNBCFCA027N 		dep_nfncb
rename NNBCEPA027N 		wn_nfncb
rename NNBESCA027N 		taxsocial_nfncb
rename NNBTPIA027N		taxprod_nfncb
rename NNBBOSA027N		nos_nfncb
rename NNBGFNA027N		i_nfncb
rename NNBCFNA027N 		ni_nfncb

* put all variables in billions
foreach x in y_nfc y_nfnc dep_nfc dep_nfnc wn_nfc wn_nfncb taxsocial_nfc taxsocial_nfnc taxprod_nfcb taxprod_nfncb i_nfc i_nfnc ni_nfc ni_nfnc nos_nfc nos_nfnc{
replace `x' = `x'/1000
}

compress
sort year
save 0.raw_inputs\fred_annual, replace





